<?php
require_once __DIR__."/../models/Customer.php";

class CustomerController {
    private $customer;
    public function __construct($pdo){
        $this->customer = new Customer($pdo);
    }

    public function index(){
        echo json_encode($this->customer->getAll());
    }

    public function store(){
        $data = json_decode(file_get_contents("php://input"), true);
        if($this->customer->create($data)){
            echo json_encode(["message" => "Customer ditambahkan"]);
        } else {
            echo json_encode(["message" => "Gagal tambah customer"]);
        }
    }

    public function update($id){
        $data = json_decode(file_get_contents("php://input"), true);
        if($this->customer->update($id, $data)){
            echo json_encode(["message" => "Customer diperbarui"]);
        } else {
            echo json_encode(["message" => "Gagal update customer"]);
        }
    }

    public function delete($id){
        if($this->customer->delete($id)){
            echo json_encode(["message" => "Customer dihapus"]);
        } else {
            echo json_encode(["message" => "Gagal hapus customer"]);
        }
    }
}
?>
