<?php
require_once __DIR__."/../models/Order.php";

class OrderController {
    private $order;
    public function __construct($pdo){
        $this->order = new Order($pdo);
    }

    public function index(){
        echo json_encode($this->order->getAll());
    }

    public function store(){
        $data = json_decode(file_get_contents("php://input"), true);
        if($this->order->create($data)){
            echo json_encode(["message" => "Pesanan dibuat"]);
        } else {
            echo json_encode(["message" => "Gagal buat pesanan"]);
        }
    }

    public function updateStatus($id){
        $data = json_decode(file_get_contents("php://input"), true);
        if($this->order->updateStatus($id, $data['status'])){
            echo json_encode(["message" => "Status pesanan diperbarui"]);
        } else {
            echo json_encode(["message" => "Gagal update status"]);
        }
    }

    public function delete($id){
        if($this->order->delete($id)){
            echo json_encode(["message" => "Pesanan dihapus"]);
        } else {
            echo json_encode(["message" => "Gagal hapus pesanan"]);
        }
    }
}
?>
