<?php
class Customer {
    private $pdo;
    public function __construct($pdo){
        $this->pdo = $pdo;
    }

    public function getAll(){
        $stmt = $this->pdo->query("SELECT * FROM customers");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function create($data){
        $stmt = $this->pdo->prepare("INSERT INTO customers (name, phone, address, latitude, longitude) VALUES (?,?,?,?,?)");
        return $stmt->execute([$data['name'], $data['phone'], $data['address'], $data['latitude'], $data['longitude']]);
    }

    public function update($id, $data){
        $stmt = $this->pdo->prepare("UPDATE customers SET name=?, phone=?, address=?, latitude=?, longitude=? WHERE id=?");
        return $stmt->execute([$data['name'], $data['phone'], $data['address'], $data['latitude'], $data['longitude'], $id]);
    }

    public function delete($id){
        $stmt = $this->pdo->prepare("DELETE FROM customers WHERE id=?");
        return $stmt->execute([$id]);
    }
}
?>
