<?php
class Order {
    private $pdo;
    public function __construct($pdo){
        $this->pdo = $pdo;
    }

    public function getAll(){
        $sql = "SELECT o.id, c.name as customer_name, o.order_date, o.status, u.name as driver_name
                FROM orders o
                JOIN customers c ON o.customer_id = c.id
                LEFT JOIN users u ON o.assigned_driver = u.id";
        $stmt = $this->pdo->query($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function create($data){
        $stmt = $this->pdo->prepare("INSERT INTO orders (customer_id, assigned_driver) VALUES (?,?)");
        return $stmt->execute([$data['customer_id'], $data['assigned_driver']]);
    }

    public function updateStatus($id, $status){
        $stmt = $this->pdo->prepare("UPDATE orders SET status=? WHERE id=?");
        return $stmt->execute([$status, $id]);
    }

    public function delete($id){
        $stmt = $this->pdo->prepare("DELETE FROM orders WHERE id=?");
        return $stmt->execute([$id]);
    }
}
?>
