<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

require_once "../config/database.php";

// Tambah customer
if (isset($_POST['add'])) {
    $name = $_POST['name'];
    $address = $_POST['address'];
    $phone = $_POST['phone'];
    $maps_link = $_POST['maps_link'];

    $latitude = null;
    $longitude = null;
    if (preg_match('/q=([-0-9.]+),([-0-9.]+)/', $maps_link, $matches)) {
        $latitude = $matches[1];
        $longitude = $matches[2];
    }

    $stmt = $pdo->prepare("INSERT INTO customers (name, address, phone, latitude, longitude, maps_link) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$name, $address, $phone, $latitude, $longitude, $maps_link]);
    $successMessage = "Customer berhasil ditambahkan!";
}

// Update customer
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $name = $_POST['name'];
    $address = $_POST['address'];
    $phone = $_POST['phone'];
    $maps_link = $_POST['maps_link'];

    $latitude = null;
    $longitude = null;
    if (preg_match('/q=([-0-9.]+),([-0-9.]+)/', $maps_link, $matches)) {
        $latitude = $matches[1];
        $longitude = $matches[2];
    }

    $stmt = $pdo->prepare("UPDATE customers SET name=?, address=?, phone=?, latitude=?, longitude=?, maps_link=? WHERE id=?");
    $stmt->execute([$name, $address, $phone, $latitude, $longitude, $maps_link, $id]);
    $successMessage = "Customer berhasil diupdate!";
}

// Delete customer
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM customers WHERE id=?");
    $stmt->execute([$id]);
    $successMessage = "Customer berhasil dihapus!";
}

// Ambil semua customers
$orderByAddress = isset($_GET['sort']) && $_GET['sort'] === 'address';
$query = "SELECT * FROM customers";
$query .= $orderByAddress ? " ORDER BY address ASC" : " ORDER BY id DESC";
$stmt = $pdo->query($query);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Ambil data customer untuk edit
$editCustomer = null;
if (isset($_GET['edit'])) {
    $id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM customers WHERE id=?");
    $stmt->execute([$id]);
    $editCustomer = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Daftar Customers - Admin</title>
<style>
body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: #eef2f7; margin: 0; padding: 20px;}
h2 { text-align: center; color: #333; margin-bottom: 20px;}
table { width: 90%; margin: auto; border-collapse: collapse; box-shadow: 0 4px 12px rgba(0,0,0,0.1);}
th, td { padding: 12px; border: 1px solid #ddd; text-align: center;}
th { background: linear-gradient(to right, #4e73df, #224abe); color: #fff; }
tr:nth-child(even) { background: #f9f9f9; }
tr:hover { background: #dbe4f7; transition: 0.3s; }
form { width: 90%; margin: 20px auto; padding: 20px; background: #fff; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);}
input, select { padding: 8px; margin: 5px 0; width: 100%; border: 1px solid #ccc; border-radius: 5px; }
.btn { padding: 10px 18px; margin: 5px 3px; background: #4e73df; color: #fff; border: none; cursor: pointer; border-radius: 5px; transition: 0.3s; }
.btn:hover { background: #224abe; }
.delete { background: #e74a3b; }
.delete:hover { background: #c42c20; }
.map-btn { text-decoration: none; padding: 8px 12px; background: #1cc88a; color: #fff; border-radius: 5px; transition: 0.3s; }
.map-btn:hover { background: #17a673; }
.back { display: inline-block; text-align: center; margin-top: 20px; text-decoration: none; padding: 10px 20px; background: #858796; color: #fff; border-radius: 5px;}
.back:hover { background: #6c757d; }
.success { text-align:center; color: green; margin-bottom: 10px; font-weight: bold; }
.sort-buttons { width: 90%; margin:auto; text-align:right; margin-bottom:10px;}
.sort-buttons a { text-decoration: none; padding: 8px 12px; background: #36b9cc; color: #fff; border-radius: 5px; margin-left: 5px; transition: 0.3s;}
.sort-buttons a:hover { background: #2c9faf; }
</style>
</head>
<body>
<h2>Daftar Customers</h2>

<?php if (isset($successMessage)): ?>
<p class="success"><?= $successMessage; ?></p>
<?php endif; ?>

<!-- Form Tambah/Edit Customer -->
<form method="post">
<?php if ($editCustomer): ?>
<h3>Edit Customer ID <?= $editCustomer['id']; ?></h3>
<input type="hidden" name="id" value="<?= $editCustomer['id']; ?>">
<input type="text" name="name" placeholder="Nama" value="<?= htmlspecialchars($editCustomer['name']); ?>" required>
<input type="text" name="address" placeholder="Alamat" value="<?= htmlspecialchars($editCustomer['address']); ?>" required>
<input type="text" name="phone" placeholder="No HP" value="<?= htmlspecialchars($editCustomer['phone']); ?>" required>
<input type="url" name="maps_link" placeholder="Masukkan link Google Maps" value="<?= htmlspecialchars($editCustomer['maps_link']); ?>" required>
<button type="submit" name="update" class="btn">Update</button>
<a href="daftar_customers.php" class="btn">Batal</a>
<?php else: ?>
<h3>Tambah Customer</h3>
<input type="text" name="name" placeholder="Nama" required>
<input type="text" name="address" placeholder="Alamat" required>
<input type="text" name="phone" placeholder="No HP" required>
<input type="url" name="maps_link" placeholder="Masukkan link Google Maps (contoh: https://www.google.com/maps?q=-6.2,106.8)" required>
<button type="submit" name="add" class="btn">Tambah</button>
<?php endif; ?>
</form>

<!-- Tombol Urut -->
<div class="sort-buttons">
    <a href="daftar_customers.php?sort=address">Urutkan Berdasarkan Alamat</a>
    <a href="daftar_customers.php">Reset Urutan</a>
</div>

<!-- Tabel Customers -->
<table>
<tr>
<th>ID</th>
<th>Nama</th>
<th>Alamat</th>
<th>No HP</th>
<th>Lokasi</th>
<th>Aksi</th>
</tr>
<?php foreach ($customers as $c): ?>
<tr>
<td><?= htmlspecialchars($c['id']); ?></td>
<td><?= htmlspecialchars($c['name']); ?></td>
<td><?= htmlspecialchars($c['address']); ?></td>
<td><?= htmlspecialchars($c['phone']); ?></td>
<td>
<?php if (!empty($c['maps_link'])): ?>
    <a href="<?= htmlspecialchars($c['maps_link']); ?>" target="_blank" class="map-btn">Lihat Lokasi</a>
<?php elseif (!empty($c['latitude']) && !empty($c['longitude'])): ?>
    <a href="https://www.google.com/maps?q=<?= $c['latitude']; ?>,<?= $c['longitude']; ?>" target="_blank" class="map-btn">Lihat Lokasi</a>
<?php else: ?>
    Tidak ada
<?php endif; ?>
</td>
<td>
<a href="?edit=<?= $c['id']; ?>" class="btn">Edit</a>
<a href="?delete=<?= $c['id']; ?>" class="btn delete" onclick="return confirm('Hapus customer ini?');">Hapus</a>
</td>
</tr>
<?php endforeach; ?>
</table>

<a href="dashboard_admin.php" class="back">⬅ Kembali ke Dashboard</a>
</body>
</html>
