<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'driver') {
    header("Location: login.php");
    exit;
}

require_once "../config/database.php";

// Ambil semua customers, dengan opsi urut berdasarkan alamat
$orderByAddress = isset($_GET['sort']) && $_GET['sort'] === 'address';
$query = "SELECT * FROM customers";
if ($orderByAddress) {
    $query .= " ORDER BY address ASC";
} else {
    $query .= " ORDER BY id DESC";
}
$stmt = $pdo->query($query);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Daftar Customers - Driver</title>
<style>
body { font-family: Arial, sans-serif; background: #e3f2fd; margin:0; padding:0;}
header { background-color: #1976d2; color:#fff; padding:25px; text-align:center; font-size:26px; font-weight:bold;}
.container { width: 95%; margin:20px auto; }
table { width:100%; border-collapse: collapse; background: #fff; border-radius:10px; overflow:hidden; box-shadow:0 5px 15px rgba(0,0,0,0.1);}
th, td { padding:12px; text-align:center; transition: all 0.2s ease; }
th { background-color: #2196f3; color: #fff; }
tr:nth-child(even) { background-color: #bbdefb; }
tr:hover { background-color: #90caf9; transform: scale(1.01); }
.map-btn { text-decoration:none; padding:5px 10px; background:#388e3c; color:#fff; border-radius:6px; display:inline-block; transition:0.2s; }
.map-btn:hover { background:#2e7d32; }
.back-btn { display:inline-block; margin:20px auto; padding:12px 25px; background:#1976d2; color:#fff; border-radius:8px; text-decoration:none; font-weight:bold; transition:0.2s; }
.back-btn:hover { background:#0d47a1; }
.sort-buttons { width:100%; margin:auto; text-align:right; margin-bottom:10px;}
</style>
</head>
<body>
<header>Daftar Customers</header>
<div class="container">

<!-- Tombol Urut -->
<div class="sort-buttons">
    <a href="daftar_customers_driver.php?sort=address" class="map-btn">Urutkan Berdasarkan Alamat</a>
    <a href="daftar_customers_driver.php" class="map-btn">Reset Urutan</a>
</div>

<!-- Tabel Customers -->
<table>
<tr>
<th>ID</th>
<th>Nama</th>
<th>Alamat</th>
<th>No HP</th>
<th>Lokasi</th>
</tr>
<?php foreach ($customers as $c): ?>
<tr>
<td><?= htmlspecialchars($c['id']); ?></td>
<td><?= htmlspecialchars($c['name']); ?></td>
<td><?= htmlspecialchars($c['address']); ?></td>
<td><?= htmlspecialchars($c['phone']); ?></td>
<td>
<?php if (!empty($c['maps_link']) || (!empty($c['latitude']) && !empty($c['longitude']))): ?>
    <?php
    $latlng = !empty($c['latitude']) && !empty($c['longitude']) ? $c['latitude'] . ',' . $c['longitude'] : '';
    $maps_url = !empty($c['maps_link']) ? $c['maps_link'] : "https://www.google.com/maps?q=".$latlng;
    ?>
    <a href="<?= htmlspecialchars($maps_url); ?>" target="_blank" class="map-btn">📍 Lihat Lokasi</a>
<?php else: ?>
    Tidak ada
<?php endif; ?>
</td>
</tr>
<?php endforeach; ?>
</table>

<a href="dashboard_driver.php" class="back-btn">⬅ Kembali ke Dashboard</a>
</div>
</body>
</html>
