<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

require_once "../config/database.php";

// Ambil list customer untuk dropdown
$customersStmt = $pdo->query("SELECT id, name, address FROM customers ORDER BY name ASC");
$customersList = $customersStmt->fetchAll(PDO::FETCH_ASSOC);

// Tambah order
if (isset($_POST['add'])) {
    $customer_id = $_POST['customer_id'];
    $jumlah = $_POST['jumlah'];
    $status_pengiriman = $_POST['status_pengiriman'];
    $order_date = date("Y-m-d");

    $stmt = $pdo->prepare("INSERT INTO orders (customer_id, jumlah, status_pengiriman, order_date) VALUES (?, ?, ?, ?)");
    $stmt->execute([$customer_id, $jumlah, $status_pengiriman, $order_date]);
    $successMessage = "Order berhasil ditambahkan!";
}

// Update order
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $customer_id = $_POST['customer_id'];
    $jumlah = $_POST['jumlah'];
    $status_pengiriman = $_POST['status_pengiriman'];
    $order_date = $_POST['order_date'];

    $stmt = $pdo->prepare("UPDATE orders SET customer_id=?, jumlah=?, status_pengiriman=?, order_date=? WHERE id=?");
    $stmt->execute([$customer_id, $jumlah, $status_pengiriman, $order_date, $id]);
    $successMessage = "Order berhasil diupdate!";
}

// Delete order
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM orders WHERE id=?");
    $stmt->execute([$id]);
    $successMessage = "Order berhasil dihapus!";
}

// Sorting
$validSort = ['order_date','jumlah','status_pengiriman'];
$sort = isset($_GET['sort']) && in_array($_GET['sort'],$validSort) ? $_GET['sort'] : 'order_date';
$sortOrder = isset($_GET['order']) && $_GET['order']=='asc' ? 'ASC' : 'DESC';
$nextOrder = $sortOrder=='ASC' ? 'desc' : 'asc';

// Ambil semua orders beserta nama customer dan alamat
$query = "
    SELECT o.id, c.name AS customer, c.address, o.jumlah, o.status_pengiriman, o.order_date, o.customer_id
    FROM orders o
    JOIN customers c ON o.customer_id = c.id
    ORDER BY $sort $sortOrder
";
$stmt = $pdo->query($query);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Ambil data order untuk edit jika ada parameter edit
$editOrder = null;
if (isset($_GET['edit'])) {
    $id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM orders WHERE id=?");
    $stmt->execute([$id]);
    $editOrder = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Admin - Daftar Orders</title>
<style>
body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: #e3f2fd; margin:0; padding:0; }
header { background-color: #1565c0; color: #fff; padding: 20px; text-align: center; font-size: 28px; font-weight: bold; }
.container { width: 95%; margin: 20px auto; }
form { background: #fff; padding: 20px; border-radius: 10px; box-shadow:0 5px 15px rgba(0,0,0,0.1); margin-bottom:20px;}
input, select { padding: 8px; margin: 5px 0; width: 100%; border-radius:5px; border:1px solid #ccc; }
.btn { padding: 10px 15px; margin:5px 0; background:#0288d1; color:#fff; border:none; border-radius:5px; cursor:pointer; transition:0.3s;}
.btn:hover { background:#0277bd; }
.delete { background:#d32f2f; }
.delete:hover { background:#b71c1c; }
.back { display:inline-block; text-align:center; margin-top:20px; text-decoration:none; padding:12px 25px; background:#1976d2; color:#fff; border-radius:8px; transition:0.3s;}
.back:hover { background:#0d47a1; }
.success { text-align:center; color: green; margin-bottom: 10px; font-weight:bold; }
table { width:100%; border-collapse:collapse; border-radius:10px; overflow:hidden; box-shadow:0 5px 15px rgba(0,0,0,0.1);}
th, td { padding:12px; text-align:center; transition: all 0.3s; }
th { background:#0288d1; color:#fff; }
tr:nth-child(even) { background:#bbdefb; }
tr:hover { background:#90caf9; transform: scale(1.01); }
th a { color:#fff; text-decoration:none; }
th a:hover { text-decoration:underline; }
</style>
</head>
<body>
<header>Daftar Orders - Admin</header>
<div class="container">
<?php if (isset($successMessage)): ?>
<p class="success"><?= $successMessage; ?></p>
<?php endif; ?>

<!-- Form Tambah/Edit Order -->
<form method="post">
<?php if ($editOrder): ?>
<h3>Edit Order ID <?= $editOrder['id']; ?></h3>
<input type="hidden" name="id" value="<?= $editOrder['id']; ?>">
<select name="customer_id" required>
    <option value="">Pilih Customer</option>
    <?php foreach($customersList as $c): ?>
        <option value="<?= $c['id']; ?>" <?= $c['id']==$editOrder['customer_id'] ? 'selected' : ''; ?>>
            <?= htmlspecialchars($c['name']); ?> - <?= htmlspecialchars($c['address']); ?>
        </option>
    <?php endforeach; ?>
</select>
<input type="number" name="jumlah" placeholder="Jumlah Pesanan" value="<?= htmlspecialchars($editOrder['jumlah']); ?>" required>
<select name="status_pengiriman" required>
    <option value="Belum" <?= $editOrder['status_pengiriman']=='Belum' ? 'selected' : ''; ?>>✖ Belum</option>
    <option value="Sudah" <?= $editOrder['status_pengiriman']=='Sudah' ? 'selected' : ''; ?>>✔ Sudah</option>
</select>
<input type="date" name="order_date" value="<?= htmlspecialchars($editOrder['order_date']); ?>" required>
<button type="submit" name="update" class="btn">Update</button>
<a href="daftar_orders.php" class="btn">Batal</a>
<?php else: ?>
<h3>Tambah Order</h3>
<select name="customer_id" required>
    <option value="">Pilih Customer</option>
    <?php foreach($customersList as $c): ?>
        <option value="<?= $c['id']; ?>"><?= htmlspecialchars($c['name']); ?> - <?= htmlspecialchars($c['address']); ?></option>
    <?php endforeach; ?>
</select>
<input type="number" name="jumlah" placeholder="Jumlah Pesanan" required>
<select name="status_pengiriman" required>
    <option value="Belum">✖ Belum</option>
    <option value="Sudah">✔ Sudah</option>
</select>
<button type="submit" name="add" class="btn">Tambah</button>
<?php endif; ?>
</form>

<!-- Tabel Orders -->
<table>
<tr>
    <th>ID</th>
    <th>Customer</th>
    <th>Alamat</th>
    <th>Jumlah Pesanan</th>
    <th>Status Pengiriman</th>
    <th><a href="?sort=order_date&order=<?= $nextOrder; ?>">Tanggal Order</a></th>
    <th>Aksi</th>
</tr>
<?php if (!empty($orders)): ?>
    <?php foreach ($orders as $row): ?>
    <tr>
        <td><?= htmlspecialchars($row['id']); ?></td>
        <td><?= htmlspecialchars($row['customer']); ?></td>
        <td><?= htmlspecialchars($row['address']); ?></td>
        <td><?= htmlspecialchars($row['jumlah']); ?></td>
        <td><?= $row['status_pengiriman']=='Sudah' ? '✔ Sudah' : '✖ Belum'; ?></td>
        <td><?= htmlspecialchars($row['order_date']); ?></td>
        <td>
            <a href="?edit=<?= $row['id']; ?>" class="btn">Edit</a>
            <a href="?delete=<?= $row['id']; ?>" class="btn delete" onclick="return confirm('Hapus order ini?');">Hapus</a>
        </td>
    </tr>
    <?php endforeach; ?>
<?php else: ?>
<tr>
    <td colspan="7">Tidak ada data orders.</td>
</tr>
<?php endif; ?>
</table>

<a href="dashboard_admin.php" class="back">⬅ Kembali ke Dashboard</a>
</div>
</body>
</html>
