<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'driver') {
    header("Location: login.php");
    exit;
}

require_once "../config/database.php";

// Update status pengiriman jika diklik
if (isset($_GET['toggle_status'])) {
    $id = $_GET['toggle_status'];

    // Ambil status saat ini
    $stmt = $pdo->prepare("SELECT status_pengiriman FROM orders WHERE id=?");
    $stmt->execute([$id]);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($order) {
        $newStatus = $order['status_pengiriman'] === 'Sudah' ? 'Belum' : 'Sudah';
        $updateStmt = $pdo->prepare("UPDATE orders SET status_pengiriman=? WHERE id=?");
        $updateStmt->execute([$newStatus, $id]);
    }

    header("Location: daftar_orders_driver.php");
    exit;
}

// Ambil semua orders beserta nama customer dan alamat
$query = "
    SELECT o.id, c.name AS customer, c.address, o.jumlah, o.status_pengiriman, o.order_date, o.customer_id
    FROM orders o
    JOIN customers c ON o.customer_id = c.id
    ORDER BY o.order_date DESC
";
$stmt = $pdo->query($query);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Daftar Orders - Driver</title>
<style>
body {
    font-family: 'Arial', sans-serif;
    background: #e3f2fd;
    margin: 0;
    padding: 0;
}
header {
    background-color: #1565c0;
    color: #fff;
    text-align: center;
    padding: 25px 0;
    font-size: 26px;
    font-weight: bold;
}
.container {
    width: 95%;
    margin: 20px auto;
}
table {
    width: 100%;
    border-collapse: collapse;
    background: #fff;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    border-radius: 10px;
    overflow: hidden;
}
th, td {
    padding: 12px;
    text-align: center;
    transition: all 0.2s ease;
}
th {
    background-color: #1976d2;
    color: #fff;
}
tr:nth-child(even) {
    background-color: #e3f2fd;
}
tr:hover {
    background-color: #bbdefb;
    transform: scale(1.01);
}
.status-badge {
    padding: 5px 12px;
    border-radius: 12px;
    color: #fff;
    font-weight: bold;
    display: inline-block;
    cursor: pointer;
    transition: background-color 0.2s;
    text-decoration: none;
}
.status-sudah { background-color: #388e3c; } /* hijau */
.status-belum { background-color: #d32f2f; } /* merah */
.status-badge:hover {
    opacity: 0.8;
}
.back-btn {
    display: inline-block;
    margin: 20px auto;
    padding: 12px 25px;
    background-color: #1565c0;
    color: #fff;
    border-radius: 8px;
    text-decoration: none;
    font-weight: bold;
    transition: background-color 0.2s;
}
.back-btn:hover { background-color: #0d47a1; }
</style>
</head>
<body>
<header>Daftar Orders - Driver</header>
<div class="container">
    <table>
        <tr>
            <th>ID</th>
            <th>Customer</th>
            <th>Alamat</th>
            <th>Jumlah Pesanan</th>
            <th>Status Pengiriman</th>
            <th>Tanggal Order</th>
        </tr>
        <?php if (!empty($orders)): ?>
            <?php foreach ($orders as $row): ?>
            <tr>
                <td><?= htmlspecialchars($row['id']); ?></td>
                <td><?= htmlspecialchars($row['customer']); ?></td>
                <td><?= htmlspecialchars($row['address']); ?></td>
                <td><?= htmlspecialchars($row['jumlah']); ?></td>
                <td>
                    <a href="?toggle_status=<?= $row['id']; ?>" 
                       class="status-badge <?= $row['status_pengiriman']=='Sudah' ? 'status-sudah' : 'status-belum'; ?>">
                        <?= $row['status_pengiriman']=='Sudah' ? '✔ Sudah' : '✖ Belum'; ?>
                    </a>
                </td>
                <td><?= htmlspecialchars($row['order_date']); ?></td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="6">Tidak ada data orders.</td></tr>
        <?php endif; ?>
    </table>

    <a href="dashboard_driver.php" class="back-btn">⬅ Kembali ke Dashboard</a>
</div>
</body>
</html>
