<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Admin</title>
<style>
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(to right, #4e73df, #1cc88a);
    color: #fff;
    text-align: center;
    min-height: 100vh;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    margin: 0;
}
h1 {
    font-size: 2.2em;
    margin-bottom: 40px;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
}
.btn-container {
    display: flex;
    gap: 30px;
    flex-wrap: wrap;
    justify-content: center;
}
.btn {
    padding: 25px 50px;
    font-size: 18px;
    color: #fff;
    text-decoration: none;
    border-radius: 12px;
    background: linear-gradient(to right, #4e73df, #224abe);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
}
.btn:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.3);
}
.logout {
    display: block;
    margin-top: 50px;
    color: #f8f9fc;
    background: #e74a3b;
    padding: 12px 25px;
    border-radius: 10px;
    text-decoration: none;
    font-weight: bold;
    transition: 0.3s ease;
}
.logout:hover {
    background: #c42c20;
    color: #fff;
}
</style>
</head>
<body>
<h1>Selamat Datang, <?= htmlspecialchars($_SESSION['user']['name']); ?> (Admin)</h1>

<div class="btn-container">
    <a href="daftar_customers.php" class="btn">Daftar Pelanggan</a>
    <a href="daftar_orders.php" class="btn">Daftar Pesanan</a>
</div>

<a href="logout.php" class="logout">Logout</a>
</body>
</html>
