<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'driver') {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Driver - Depot Air</title>
<style>
body {
    font-family: 'Arial', sans-serif;
    background: #e0f7fa;
    margin: 0;
    padding: 0;
}
header {
    background-color: #00796b;
    color: #fff;
    text-align: center;
    padding: 30px 0;
    font-size: 28px;
    font-weight: bold;
}
.container {
    display: flex;
    justify-content: center;
    align-items: center;
    height: calc(100vh - 200px);
    gap: 40px;
    flex-wrap: wrap;
}
.dashboard-card {
    width: 220px;
    height: 180px;
    background-color: #fff;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    text-decoration: none;
    color: #fff;
    font-size: 20px;
    font-weight: bold;
    transition: transform 0.2s, box-shadow 0.2s;
}
.dashboard-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.3);
}
.card-customers { background-color: #0288d1; }
.card-orders { background-color: #d32f2f; }
.card-icon {
    font-size: 50px;
    margin-bottom: 15px;
}
.action-buttons {
    width: 100%;
    text-align: center;
    margin-top: 20px;
}
.action-buttons a {
    display: inline-block;
    margin: 10px;
    padding: 12px 25px;
    background-color: #6c757d;
    color: #fff;
    border-radius: 8px;
    text-decoration: none;
    font-weight: bold;
    transition: background-color 0.2s;
}
.action-buttons a:hover {
    background-color: #5a6268;
}
footer {
    text-align: center;
    padding: 20px;
    background-color: #00796b;
    color: #fff;
}
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
<header>
    Dashboard Driver
</header>
<div class="container">
    <a href="daftar_customers_driver.php" class="dashboard-card card-customers">
        <i class="fas fa-users card-icon"></i>
        Pelanggan
    </a>
    <a href="daftar_orders_driver.php" class="dashboard-card card-orders">
        <i class="fas fa-truck card-icon"></i>
        Pesanan
    </a>
</div>

<!-- Tombol Logout & Kembali -->
<div class="action-buttons">
    <a href="logout.php">Logout</a>
</div>

<footer>
    &copy; <?= date("Y"); ?> Depot Air Minum
</footer>
</body>
</html>
