<?php
session_start();
if (isset($_SESSION['user'])) {
    // kalau sudah login, langsung ke dashboard
    if ($_SESSION['user']['role'] === 'admin') {
        header("Location: dashboard_admin.php");
    } else {
        header("Location: dashboard_driver.php");
    }
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Panggil API login
    $ch = curl_init("http://localhost/depot/public/login");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        "username" => $username,
        "password" => $password
    ]));

    $response = curl_exec($ch);
    $data = json_decode($response, true);
    var_dump($data);
    curl_close($ch);

    if (isset($data['user'])) {
        $_SESSION['user'] = $data['user'];
        if ($data['user']['role'] === 'admin') {
            header("Location: dashboard_admin.php");
        } else {
            header("Location: dashboard_driver.php");
        }
        exit;
    } else {
        $error = $data['message'] ?? "Login gagal";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login Depot Air Galon</title>
</head>
<body>
    <h2>Login</h2>
    <?php if (!empty($error)): ?>
        <p style="color:red;"><?= $error ?></p>
    <?php endif; ?>
    <form method="POST">
        <label>Username</label><br>
        <input type="text" name="username" required><br><br>
        <label>Password</label><br>
        <input type="password" name="password" required><br><br>
        <button type="submit">Login</button>
    </form>
</body>
</html>
