<?php
session_start();
include __DIR__ . "/../config/database.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        if (password_verify($password, $row['password'])) {
            $_SESSION['user'] = [
                'id'       => $row['id'],
                'username' => $row['username'],
                'role'     => $row['role'],
                'name'     => $row['name'] ?? $row['username']
            ];

            if ($row['role'] === 'admin') {
                header("Location: dashboard_admin.php");
            } else {
                header("Location: dashboard_driver.php");
            }
            exit();
        } else {
            $error = "Password salah";
        }
    } else {
        $error = "Username tidak ditemukan";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Login Depot Air Galon</title>
<style>
@import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
body {
    font-family: 'Roboto', sans-serif;
    background: linear-gradient(135deg, #1cc88a, #4e73df);
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    margin: 0;
}
.login-container {
    background: #fff;
    padding: 40px 50px;
    border-radius: 15px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
    text-align: center;
    width: 350px;
}
.login-container h2 {
    margin-bottom: 30px;
    color: #333;
}
.login-container input {
    width: 100%;
    padding: 12px 15px;
    margin: 10px 0;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 16px;
}
.login-container button {
    width: 100%;
    padding: 12px;
    background: #4e73df;
    border: none;
    color: #fff;
    font-size: 18px;
    border-radius: 8px;
    cursor: pointer;
    transition: 0.3s ease;
}
.login-container button:hover {
    background: #224abe;
}
.error {
    color: #dc3545;
    margin-bottom: 15px;
    font-weight: bold;
}
.login-footer {
    margin-top: 20px;
    font-size: 14px;
    color: #666;
}
</style>
</head>
<body>
<div class="login-container">
    <h2>Login Depot Air Galon</h2>
    <?php if (!empty($error)): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <form method="POST">
        <input type="text" name="username" placeholder="Username" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit">Login</button>
    </form>
    <div class="login-footer">
        &copy; <?= date("Y"); ?> Depot Air Galon
    </div>
</div>
</body>
</html>
