<?php
require_once __DIR__."/../config/database.php";
require_once __DIR__."/../controllers/AuthController.php";
require_once __DIR__."/../controllers/CustomerController.php";
require_once __DIR__."/../controllers/OrderController.php";

$authController = new AuthController($pdo);
$customerController = new CustomerController($pdo);
$orderController = new OrderController($pdo);

// Hilangkan prefix folder project dari URI
$basePath = "/Depot/public";   // <- sesuaikan dengan nama folder project kamu
$uri = str_replace($basePath, "", strtok($_SERVER["REQUEST_URI"], '?'));
$method = $_SERVER["REQUEST_METHOD"];

// Login
if ($uri == "/login" && $method == "POST") {
    $authController->login();
}

// Customers
elseif ($uri == "/customers" && $method == "GET") {
    $customerController->index();
} elseif ($uri == "/customers" && $method == "POST") {
    $customerController->store();
} elseif (preg_match("#^/customers/(\d+)$#", $uri, $matches) && $method == "PUT") {
    $customerController->update($matches[1]);
} elseif (preg_match("#^/customers/(\d+)$#", $uri, $matches) && $method == "DELETE") {
    $customerController->delete($matches[1]);
}

// Orders
elseif ($uri == "/orders" && $method == "GET") {
    $orderController->index();
} elseif ($uri == "/orders" && $method == "POST") {
    $orderController->store();
} elseif (preg_match("#^/orders/(\d+)/status$#", $uri, $matches) && $method == "PUT") {
    $orderController->updateStatus($matches[1]);
}

// Jika tidak cocok
else {
    echo json_encode(["message" => "Endpoint tidak ditemukan", "uri" => $uri]);
}
